{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Tel.: +0351-8012255                   =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 04.03.98 - 00:47:04 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMAbout,
  MMUtils,
  MMCCon,
  MMDesign,
  MMObj,
  MMPanel,
  MMWheel,
  MMButton,
  MMBmpLst,
  MMBmpBtn,
  MMHook,
  MMFill,
  MMLEDS,
  MMDIBCv,
  MMLevel,
  MMHTimer,
  MMPCX,
  MMPCXCtl,
  MMPCXTol;

type
  TMainForm = class(TForm)
    PCXCard: TMMPCXCard;
    MMDesigner1: TMMDesigner;
    PlayStream: TMMPCXOutputStream;
    PCXConnector: TMMPCXConnector;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    About1: TMenuItem;
    menNew: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    MMPanel1: TMMPanel;
    MMBitmapList1: TMMBitmapList;
    btnStop: TMMBitmapButton;
    btnRecord: TMMBitmapButton;
    btnPause: TMMBitmapButton;
    MMFormFill1: TMMFormFill;
    ledMode: TMMLEDMode;
    MMLevelScale1: TMMLevelScale;
    digit: TMMLEDDigit;
    MMLevel2: TMMLevel;
    MMLevel1: TMMLevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ss: TMMLEDDigit;
    ss2: TMMLEDDigit;
    mm: TMMLEDDigit;
    mm2: TMMLEDDigit;
    Gauge: TMMLevel;
    lblBitRate: TLabel;
    lblLayer: TLabel;
    lblLayer2: TLabel;
    ledBitRate: TMMLEDPanel;
    Timer1: TMMHiTimer;
    PlayPipe: TMMPCXPipe;
    RecPipe: TMMPCXPipe;
    RecStream: TMMPCXInputStream;
    procedure menNewClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure RecStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
  private
    StartPos: Longint;
    procedure   CreateParams(var Params: TCreateParams); override;

  public
    procedure SetFileParams;

  end;

var
  MainForm: TMainForm;

implementation

uses Unit2;

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TMainForm.CreateParams(var Params: TCreateParams);
begin
   inherited CreateParams(Params);
   Params.Style := Params.Style and not WS_SIZEBOX;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   { allocate the Pipe }
   PlayPipe.Allocate;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   btnStopClick(nil);
   { release the Pipe }
   PlayPipe.Release;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.SetFileParams;
begin
   with RecStream.Format do
   begin
      if (FileFormat <> ftWAV) then
      begin
         lblLayer.Visible := True;
         lblLayer2.Visible:= True;
         case MPEGLayer of
             mLayer1: lblLayer2.Caption := 'I';
             mLayer2: lblLayer2.Caption := 'II';
         end;

         ledBitRate.Value := MPEGBitRate;
         ledBitRate.Visible := True;
         lblBitRate.Visible := True;
      end
      else
      begin
         lblLayer.Visible  := False;
         lblLayer2.Visible := False;
         ledBitRate.Visible:= False;
         lblBitRate.Visible := False;
      end;

      ledMode.Mode := Mode;
      ledMode.Visible := True;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.menNewClick(Sender: TObject);
begin
   if (FormatDlg.ShowModal = mrOK) then
   begin
      RecStream.FileName := FormatDlg.FileName;
      btnRecord.Enabled := True;
      SetFileParams;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{------------------------------------------------------------------------------}
procedure TMainForm.RecStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
begin
   case Reason of
       nBeforeEndStream: ;
       nBeginFile      : ;
       nCloseFile      : begin
                            menNew.Enabled := True;
                            Timer1.Enabled := False;
                            btnRecord.Down    := False;
                            btnPause.Enabled := False;
                            btnStop.Enabled := False;
                            PlayPipe.Stop;
                         end;
       nEndFile        : ;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnRecordClick(Sender: TObject);
begin
   if (PlayPipe.Status = psStopped) then
   begin
      btnRecord.Down := True;

      { here you can also start a file to play }
      //PlayStream.FileName := 'XXX';
      //PlayStream.Prepare(0,PLAY_ALL_FILE);
      //PlayStream.Play;

      RecStream.Prepare(RECORD_UNTIL_STOP);
      RecStream.Recording;

      { Play Pipe is Master ! }
      PlayPipe.Start;

      menNew.Enabled := False;
      btnStop.Enabled := True;
      Timer1.Enabled := True;
   end
   else btnRecord.Down := True;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   RecStream.Stop;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.Timer1Timer(Sender: TObject);
Var
   Elapsed,Remaining: DWORD;
   Hour, Min, Sec, MSec: Word;

begin
   RecStream.Position(Elapsed, Remaining);

   TimeDecode(Elapsed, Hour, Min, Sec, MSec);

   ss.Value := Sec;
   mm.Value := Min;
end;

end.
